#ifndef _ltc2498spi_h_
#define _ltc2498spi_h_ 1


//Use these by ORing the Channel and the Setting together and sending as first byte

#define LTC2498_CHANNEL_MASK               (0x80)

/* 
** SPI Channel Settings (the Third to 8th MSB)
** EN1: Channel Change Enable
** S/D: Single Ended / ~Differential
** O/S: Odd (single) / ~Sign (diff)
** S2: Channel bit 2
** S1: Channel bit 1
** S0: Channel bit 0
** Defined as the top nibble of the data byte
*/

//This is from TABLE 3 of the LTC2498 datasheet
#define LTC2498_NO_CHANNEL_CHANGE          (0x00)

#define LTC2498_DIFF_01                    (0x20)
#define LTC2498_DIFF_23                    (0x21)
#define LTC2498_DIFF_45                    (0x22)
#define LTC2498_DIFF_67                    (0x23)
#define LTC2498_DIFF_89                    (0x24)
#define LTC2498_DIFF_1011                  (0x25)
#define LTC2498_DIFF_1213                  (0x26)
#define LTC2498_DIFF_1415                  (0x27)

#define LTC2498_DIFF_10                    (0x28)
#define LTC2498_DIFF_32                    (0x29)
#define LTC2498_DIFF_54                    (0x2A)
#define LTC2498_DIFF_76                    (0x2B)
#define LTC2498_DIFF_98                    (0x2C)
#define LTC2498_DIFF_1110                  (0x2D)
#define LTC2498_DIFF_1312                  (0x2E)
#define LTC2498_DIFF_1514                  (0x2F)

//This is from TABLE 3 of the LTC2498 datasheet
#define LTC2498_SING_0                     (0x30)
#define LTC2498_SING_1                     (0x38)
#define LTC2498_SING_2                     (0x31)
#define LTC2498_SING_3                     (0x39)
#define LTC2498_SING_4                     (0x32)
#define LTC2498_SING_5                     (0x3A)
#define LTC2498_SING_6                     (0x33)
#define LTC2498_SING_7                     (0x3B)
#define LTC2498_SING_8                     (0x34)
#define LTC2498_SING_9                     (0x3C)
#define LTC2498_SING_10                    (0x35)
#define LTC2498_SING_11                    (0x3D)
#define LTC2498_SING_12                    (0x36)
#define LTC2498_SING_13                    (0x3E)
#define LTC2498_SING_14                    (0x37)
#define LTC2498_SING_15                    (0x3F)


/* 
** SPI Speed and Rejection Settings
** Defined as the bottom of the first byte after slave address
*/

#define LTC2498_KEEP_PREVIOUS_SETTING      (0x00)

#define LTC2498_EXT_REJECT_50_60_X1        (0x80)
#define LTC2498_EXT_REJECT_50_X1           (0x90)
#define LTC2498_EXT_REJECT_60_X1           (0xA0)

#define LTC2498_EXT_REJECT_50_60_X2        (0x88)
#define LTC2498_EXT_REJECT_50_X2           (0x98)

#define LTC2498_TEMP_REJECT_50_60_X1       (0xC0)
#define LTC2498_TEMP_REJECT_50_X1          (0xD0)
#define LTC2498_TEMP_REJECT_60_X1          (0xE0)



//Channel Lookup
static const uint_8 LTC2498ChannelSelect[] = 
{
	LTC2498_NO_CHANNEL_CHANGE,

	LTC2498_DIFF_01,
	LTC2498_DIFF_23,
	LTC2498_DIFF_45,
	LTC2498_DIFF_67,
	LTC2498_DIFF_89,
	LTC2498_DIFF_1011,
	LTC2498_DIFF_1213,
	LTC2498_DIFF_1415,

	LTC2498_DIFF_10,
	LTC2498_DIFF_32,
	LTC2498_DIFF_54,
	LTC2498_DIFF_76,
	LTC2498_DIFF_98,
	LTC2498_DIFF_1110,
	LTC2498_DIFF_1312,
	LTC2498_DIFF_1514,

	LTC2498_SING_0,
	LTC2498_SING_1,
	LTC2498_SING_2,
	LTC2498_SING_3,
	LTC2498_SING_4,
	LTC2498_SING_5,
	LTC2498_SING_6,
	LTC2498_SING_7,
	LTC2498_SING_8,
	LTC2498_SING_9,
	LTC2498_SING_10,
	LTC2498_SING_11,
	LTC2498_SING_12,
	LTC2498_SING_13,
	LTC2498_SING_14,
	LTC2498_SING_15,

};

static const uint_8 LTC2498SettingSelect[] = 
{
	LTC2498_KEEP_PREVIOUS_SETTING,
	LTC2498_EXT_REJECT_50_60_X1,
	LTC2498_EXT_REJECT_50_X1, 
	LTC2498_EXT_REJECT_60_X1,
	LTC2498_EXT_REJECT_50_60_X2,
	LTC2498_EXT_REJECT_50_X2, 
	LTC2498_TEMP_REJECT_50_60_X1,
	LTC2498_TEMP_REJECT_50_X1,
	LTC2498_TEMP_REJECT_60_X1    

};


//Channel Lookup for Data Logger
static const uint_8 LTC2498LoggerChannelSelect[] = 
{
	LTC2498_DIFF_01,
	LTC2498_DIFF_23,
	LTC2498_DIFF_45,
	LTC2498_DIFF_67,


	LTC2498_DIFF_10,
	LTC2498_DIFF_32,
	LTC2498_DIFF_54,
	LTC2498_DIFF_76,

	LTC2498_SING_0,
	LTC2498_SING_1,
	LTC2498_SING_2,
	LTC2498_SING_3,
	LTC2498_SING_4,
	LTC2498_SING_5,
	LTC2498_SING_6,
	LTC2498_SING_7

};



//Function Definitions

extern uint_32		send_receive_LTC2498 (uint_8, uint_8, FILE_PTR);



#endif /* _ltc2498spi_h_ */